//
// TRACKER SCHEME RESOURCE FILE
//
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
// notes:
// 		hit ctrl-alt-shift-R in the app to reload this file
//
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		"BaseText" "255 255 255 255"
		"BrightBaseText" "194 194 194 255"
		"SelectedText" "253 253 252 255"
		"DimBaseText" "255 255 0 255"
		"LabelDimText" "211 211 211 255"
		"ControlText" "151 151 151 255"
		"BrightControlText" "0 114 255 255"
		"DisabledText1" "50 50 50 255"
		"DisabledText2" "55 55 55 255"
		"DimListText" "25 25 25 255"
		"ControlBG" "25 25 25 157"
		"ControlDarkBG" "37 37 37 34"
		"WindowBG" "10 10 10 144"
		"SelectionBG" "11 154 253 200"
		"SelectionBG2" "25 25 25 255"
		"ListBG" "10 10 10 212"
		"TitleText" "255 240 0 255"
		"TitleDimText" "11 154 253 255"
		"TitleBG" "0 0 0 0"
		"TitleDimBG" "0 0 0 0"
		"SliderTickColor" "149 149 149 255"
		"SliderTrackColor" "71 71 71 255"
		"BorderBright" "37 37 37 175"
		"BorderDark" "30 30 30 175"
		"BorderSelection" "0 0 0 255"

	}


	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		"FgColor"			"LabelDimText"
		"BgColor"			"ControlBG"
		"LabelBgColor"			"0 0 0 0"
		"SubPanelBgColor"		"ControlBG"
		"DisabledFgColor1"		"255 255 255 255"	
		"DisabledFgColor2"		"255 255 255 255" 			// set this to the BgColor if you don't want it to draw
		"TitleBarFgColor"		"255 255 255 255"
		"TitleBarDisabledFgColor"	"255 255 255 255"
		"TitleBarBgColor"		"0 0 0 0"
		"TitleBarDisabledBgColor"	"0 0 0 0"
		"TitleBarIcon"			"resource/icon_steam"
		"TitleBarDisabledIcon"		"resource/icon_steam_disabled"
		"TitleButtonFgColor"		"255 255 255 255"
		"TitleButtonBgColor"		"0 0 0 255"
		"TitleButtonDisabledFgColor"	"255 255 255 255"
		"TitleButtonDisabledBgColor"	"0 0 0 255"
		"TextCursorColor"		"BaseText"
		"URLTextColor"			"255 255 255 255"	// color that URL's show up in chat window

		Menu
		{
			"FgColor" "BaseText"
			"BgColor" "ControlBG"
			"ArmedFgColor" "DimBaseText"
			"ArmedBgColor" "SelectionBG"
			"DividerColor" "BorderDark"
			"TextInset" "6"
		}
		MenuButton
		{
			"ButtonArrowColor" "DimBaseText"
			"ButtonBgColor" "WindowBG"
			"ArmedArrowColor" "BrightBaseText"
			"ArmedBgColor" "DimBaseText"
		}
		Slider
		{
			"SliderFgColor" "ControlBG"
			"SliderBgColor" "ControlDarkBG"
		}
		ScrollBarSlider
		{
			"BgColor" "ControlBG"
			"ScrollBarSliderFgColor" "DisabledText1"
			"ScrollBarSliderBgColor" "ControlDarkBG"
			"ButtonFgColor" "DimBaseText"
		}
		"WindowFgColor" "BaseText"
		"WindowBgColor" "WindowBG"
		"WindowDisabledFgColor" "BaseText"
		"WindowDisabledBgColor" "ListBG"
		"SelectionFgColor" "SelectedText"
		"SelectionBgColor" "SelectionBG"
		"ListSelectionFgColor" "SelectedText"
		"ListBgColor" "ListBG"
		"BuddyListBgColor" "ListBG"
		"ChatBgColor" "WindowBG"
		"StatusSelectFgColor" "BrightBaseText"
		"StatusSelectFgColor2" "BrightControlText"
		"CheckButtonBorder1" "BorderDark"
		"CheckButtonBorder2" "BorderBright"
		"CheckButtonCheck" "BrightControlText"
		"CheckBgColor" "ListBG"
		BuddyButton
		{
			"FgColor1" "ControlText"
			"FgColor2" "DimListText"
			"ArmedFgColor1" "BrightBaseText"
			"ArmedFgColor2" "BrightBaseText"
			"ArmedBgColor" "SelectionBG"
		}
		Chat
		{
			"TextColor" "BrightControlText"
			"SelfTextColor" "BaseText"
			"SeperatorTextColor" "DimBaseText"
		}
		InGameDesktop
		{
			"MenuColor" "255 255 255 255"
			"ArmedMenuColor" "255 255 0 255"
			"DepressedMenuColor" "192 186 80 255"
			"WidescreenBarColor" "0 0 0 0"
			"MenuItemVisibilityRate" "0.03" "MenuItemHeight" "28"
			"GameMenuInset" "32"
		}
		"SectionTextColor" "BrightControlText"
		"SectionDividerColor" "BorderDark"
	}

	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		"Default"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"500"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"0"
				"underline" "1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
			}
		}
		"DefaultSmallBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"600"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}
"MenuLarge"
{
"1"
{
"Name" "Verdana"
"Tall" "18"
"Weight" "1000"
"antialias" "0"
}
}
		"UiHeadline"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"18"
				"weight"	"1000"
				"antialias" "0"
			}
		}

		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}
		
		"EngineFont"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"	"600"
				"yres"	"480 599"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13"
				"weight"	"600"
				"yres"	"600 767"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14"
				"weight"	"600"
				"yres"	"768 1023"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"600"
				"yres"	"1024 1199"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24"
				"weight"	"600"
				"yres"	"1200 6000"
				"dropshadow"	"1"
			}
		}	
		
		"CreditsFont"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"600"
				"antialias"	"1"
			}
		}

		"Legacy_CreditsFont" // Added to accomodate 3rd party server plugins, etc. This version should not scale.
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"700"
				"antialias"	"1"
				"yres"	"1 10000"
			}
		}
	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		// references to other borders
		BaseBorder		"InsetBorder"
		ComboBoxBorder	"InsetBorder"
		BrowserBorder	"InsetBorder"
		ButtonBorder	"RaisedBorder"
		FrameBorder		"RaisedBorder"
		TabBorder		"RaisedBorder"
		MenuBorder		"RaisedBorder"
		
		// standard borders
		InsetBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// special border types
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"4"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 1"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
	}
}